/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.util;

import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector2fc;
import org.joml.Vector3fc;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryUtil;

public final class ExtraMemoryOps {
    private ExtraMemoryOps() {
    }

    public static void put4x8(long ptr, int value) {
        MemoryUtil.memPutByte((long)ptr, (byte)((byte)(value & 0xFF)));
        MemoryUtil.memPutByte((long)(ptr + 1L), (byte)((byte)(value >>> 8 & 0xFF)));
        MemoryUtil.memPutByte((long)(ptr + 2L), (byte)((byte)(value >>> 16 & 0xFF)));
        MemoryUtil.memPutByte((long)(ptr + 3L), (byte)((byte)(value >>> 24 & 0xFF)));
    }

    public static void put2x16(long ptr, int value) {
        MemoryUtil.memPutShort((long)ptr, (short)((short)(value & 0xFFFF)));
        MemoryUtil.memPutShort((long)(ptr + 2L), (short)((short)(value >>> 16 & 0xFFFF)));
    }

    public static void putVector2f(long ptr, Vector2fc vector) {
        MemoryUtil.memPutFloat((long)ptr, (float)vector.x());
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)vector.y());
    }

    public static void putVector3f(long ptr, Vector3fc vector) {
        MemoryUtil.memPutFloat((long)ptr, (float)vector.x());
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)vector.y());
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)vector.z());
    }

    public static void putVector4f(long ptr, Vector4fc vector) {
        MemoryUtil.memPutFloat((long)ptr, (float)vector.x());
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)vector.y());
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)vector.z());
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)vector.w());
    }

    public static void putQuaternionf(long ptr, Quaternionfc quaternion) {
        MemoryUtil.memPutFloat((long)ptr, (float)quaternion.x());
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)quaternion.y());
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)quaternion.z());
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)quaternion.w());
    }

    public static void putMatrix3f(long ptr, Matrix3fc matrix) {
        MemoryUtil.memPutFloat((long)ptr, (float)matrix.m00());
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)matrix.m01());
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)matrix.m02());
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)matrix.m10());
        MemoryUtil.memPutFloat((long)(ptr + 16L), (float)matrix.m11());
        MemoryUtil.memPutFloat((long)(ptr + 20L), (float)matrix.m12());
        MemoryUtil.memPutFloat((long)(ptr + 24L), (float)matrix.m20());
        MemoryUtil.memPutFloat((long)(ptr + 28L), (float)matrix.m21());
        MemoryUtil.memPutFloat((long)(ptr + 32L), (float)matrix.m22());
    }

    public static void putMatrix3fPadded(long ptr, Matrix3fc matrix) {
        MemoryUtil.memPutFloat((long)ptr, (float)matrix.m00());
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)matrix.m01());
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)matrix.m02());
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)0.0f);
        MemoryUtil.memPutFloat((long)(ptr + 16L), (float)matrix.m10());
        MemoryUtil.memPutFloat((long)(ptr + 20L), (float)matrix.m11());
        MemoryUtil.memPutFloat((long)(ptr + 24L), (float)matrix.m12());
        MemoryUtil.memPutFloat((long)(ptr + 28L), (float)0.0f);
        MemoryUtil.memPutFloat((long)(ptr + 32L), (float)matrix.m20());
        MemoryUtil.memPutFloat((long)(ptr + 36L), (float)matrix.m21());
        MemoryUtil.memPutFloat((long)(ptr + 40L), (float)matrix.m22());
        MemoryUtil.memPutFloat((long)(ptr + 44L), (float)0.0f);
    }

    public static void putMatrix4f(long ptr, Matrix4fc matrix) {
        MemoryUtil.memPutFloat((long)ptr, (float)matrix.m00());
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)matrix.m01());
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)matrix.m02());
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)matrix.m03());
        MemoryUtil.memPutFloat((long)(ptr + 16L), (float)matrix.m10());
        MemoryUtil.memPutFloat((long)(ptr + 20L), (float)matrix.m11());
        MemoryUtil.memPutFloat((long)(ptr + 24L), (float)matrix.m12());
        MemoryUtil.memPutFloat((long)(ptr + 28L), (float)matrix.m13());
        MemoryUtil.memPutFloat((long)(ptr + 32L), (float)matrix.m20());
        MemoryUtil.memPutFloat((long)(ptr + 36L), (float)matrix.m21());
        MemoryUtil.memPutFloat((long)(ptr + 40L), (float)matrix.m22());
        MemoryUtil.memPutFloat((long)(ptr + 44L), (float)matrix.m23());
        MemoryUtil.memPutFloat((long)(ptr + 48L), (float)matrix.m30());
        MemoryUtil.memPutFloat((long)(ptr + 52L), (float)matrix.m31());
        MemoryUtil.memPutFloat((long)(ptr + 56L), (float)matrix.m32());
        MemoryUtil.memPutFloat((long)(ptr + 60L), (float)matrix.m33());
    }
}

